﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Environment

Public Class MainForm

#Region " 枚举处理 "
    Private Sub LoadList(ByVal lst As ListBox, ByVal typ As Type)
        lst.DataSource = System.Enum.GetNames(typ)
    End Sub

    Private Function GetSpecialFolderFromList() As Environment.SpecialFolder
        ' lstFolders.SelectedItem 返回特殊文件夹的名称。
        ' System.Enum.Parse 将该文件夹名转变为
        ' 一个与匹配特定文本的枚举值相对应的对象。
        ' 然后，CType 将该对象转换为
        ' Environment.SpecialFolder 对象。
        ' 这都是必需的，因为 Option Strict 已启用。
        Return CType( _
        System.Enum.Parse(GetType(Environment.SpecialFolder), _
        lstFolders.SelectedItem.ToString), _
        Environment.SpecialFolder)
    End Function

    Private Sub LoadList(ByVal lst As ListBox, ByVal ic As ICollection)
        ' 此过程将列表框的数据源
        ' 设置为实现 ICollection 接口的
        ' 的对象的内容。
        ' 必须首先将这些内容复制到
        ' 实现 IList 的某一对象
        ' （如数组），
        ' 然后绑定到该对象。
        Dim astrItems(ic.Count - 1) As String
        ic.CopyTo(astrItems, 0)
        lst.DataSource = astrItems
    End Sub
#End Region

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        Environment.Exit(CInt(nudExitCode.Value))
    End Sub

    Private Sub btnExpand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExpand.Click
        lblExpandResults.Text = Environment.ExpandEnvironmentVariables(txtExpand.Text)
    End Sub

    Private Sub btnGetEnvironmentVariable_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetEnvironmentVariable.Click
        lblTEMP.Text = Environment.GetEnvironmentVariable("TEMP")
    End Sub

    Private Sub btnGetSystemFolder_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetSystemFolder.Click
        ' 如果只需要检索单个
        ' 特殊文件夹路径，
        ' 则传入 SpecialFolder 枚举值之一即可。
        ' GetFolderPath 实际上是 System.Environment.GetFolderPath。
        ' 请参见此文件顶部的 Imports 语句。
        lblSystemFolder.Text = GetFolderPath(SpecialFolder.System)
    End Sub

    Private Sub btnRefreshTickCount_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRefreshTickCount.Click
        lblTickCount.Text = Environment.TickCount.ToString
    End Sub

    Private Sub btnStackTrace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStackTrace.Click
        Try
            MsgBox(Environment.StackTrace, MsgBoxStyle.OKOnly, Me.Text)
        Catch exp As System.Security.SecurityException
            MsgBox("A security exception occurred." & vbCrLf & exp.Message, MsgBoxStyle.Critical, exp.Source)
        Catch exp As System.Exception
            MsgBox("An unexpected error occurred accessing the StackTrace." & vbCrLf & exp.Message, MsgBoxStyle.Critical, exp.Source)
        End Try
    End Sub

    Private Sub frmEnvironment_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' LoadList 过程位于
        ' 上述“枚举处理”区域。
        ' 它加载一个包含所有枚举
        ' 元素的列表框。如果您感兴趣，
        ' 可以看一下。可以通过一次加载一项的方式加载一个包含项的
        ' 列表，而且此方法
        ' 更为简单。
        LoadList(lstFolders, GetType(Environment.SpecialFolder))

        ' LoadList（位于“枚举处理”
        ' 区域中）还加载一个给定
        ' ICollection 对象的列表框。该替代方法将
        ' 循环访问该集合的所有元素。
        LoadList(lstEnvironmentVariables, GetEnvironmentVariables.Keys)

        ' 在“Properties”（属性）选项卡上显示属性。
        LoadProperties()

        ' 创建简单方法。
        RunMethods()

        ' 从 SystemInformation 类中加载值
        LoadSystemInformation()
    End Sub

    Private Sub lstEnvironmentVariables_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstEnvironmentVariables.SelectedIndexChanged
        ' GetEnvironmentVariable 实际上是 
        ' System.Environment.GetEnvironmentVariable。
        ' lstEnvironmentVariables 包含一个由
        ' 所有当前环境变量组成的列表。
        ' GetEnvironmentVariable 返回与环境变量
        ' 关联的值。
        lblEnvironmentVariable.Text = _
        GetEnvironmentVariable(lstEnvironmentVariables.SelectedItem.ToString)
    End Sub

    Private Sub lstFolders_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstFolders.SelectedIndexChanged
        Dim sf As Environment.SpecialFolder

        ' GetSpecialFolderFromList 是一个位于上述
        ' 隐藏的“枚举处理”区域中
        ' 的方法。它返回
        ' Environment.SpecialFolder 枚举的成员，
        ' 并且特定于此演示。
        sf = GetSpecialFolderFromList()

        ' GetFolderPath 是由一个由 
        ' System.Environment 命名空间提供的方法。

        ' 具体来说，可以按如下所示调用 GetFolderPath 
        ' 方法：
        ' YourPath = GetFolderPath(SpecialFolder.Favorites)

        ' GetFolderPath 实际上是 System.Environment.GetFolderPath。
        ' 请参见此文件顶部的 Imports 语句。
        lblSpecialFolder.Text = GetFolderPath(sf)
    End Sub

    Private Sub lvwSystemInformation_Resize(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lvwSystemInformation.Resize
        lvwSystemInformation.Columns(1).Width = _
        lvwSystemInformation.ClientRectangle.Width - lvwSystemInformation.Columns(0).Width
    End Sub

    Private Sub LoadProperties()
        ' 该过程填充
        ' “Properties”（属性）选项卡上的项。这些项
        ' 绝大多数是由 Environment
        ' 类提供的属性。
        lblWorkingSet.Text = Environment.WorkingSet.ToString
        lblVersion.Text = Environment.Version.ToString
        lblUserName.Text = Environment.UserName
        lblUserDomainName.Text = Environment.UserDomainName
        lblTickCount.Text = Environment.TickCount.ToString
        lblSystemDirectory.Text = Environment.SystemDirectory
        lblOSVersion.Text = Environment.OSVersion.ToString
        lblMachineName.Text = Environment.MachineName
        lblCurrentDirectory.Text = Environment.CurrentDirectory
        lblCommandLine.Text = Environment.CommandLine
    End Sub

    Private Sub LoadSystemInformation()
        ' 将有关 SystemInformation 类的共享属性的信息
        ' 添加到 ListView 控件中。
        ' 该项的文本是
        ' SystemInformation 类所提供的
        ' 属性名称。第一个（并且只有一个）
        ' 子项是该属性值。
        ' 有关各属性的更多信息，请参见有关
        ' SystemInformation 类
        ' 的帮助。
        With lvwSystemInformation.Items.Add("ArrangeDirection")
            .SubItems.Add(SystemInformation.ArrangeDirection.ToString())
        End With
        With lvwSystemInformation.Items.Add("ArrangeStartingPosition")
            .SubItems.Add(SystemInformation.ArrangeStartingPosition.ToString())
        End With
        With lvwSystemInformation.Items.Add("BootMode")
            .SubItems.Add(SystemInformation.BootMode.ToString())
        End With
        With lvwSystemInformation.Items.Add("Border3DSize")
            .SubItems.Add(SystemInformation.Border3DSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("BorderSize")
            .SubItems.Add(SystemInformation.BorderSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("CaptionButtonSize")
            .SubItems.Add(SystemInformation.CaptionButtonSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("CaptionHeight")
            .SubItems.Add(SystemInformation.CaptionHeight.ToString())
        End With
        With lvwSystemInformation.Items.Add("ComputerName")
            .SubItems.Add(SystemInformation.ComputerName.ToString())
        End With
        With lvwSystemInformation.Items.Add("CursorSize")
            .SubItems.Add(SystemInformation.CursorSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("DbcsEnabled")
            .SubItems.Add(SystemInformation.DbcsEnabled.ToString())
        End With
        With lvwSystemInformation.Items.Add("DebugOS")
            .SubItems.Add(SystemInformation.DebugOS.ToString())
        End With
        With lvwSystemInformation.Items.Add("DoubleClickSize")
            .SubItems.Add(SystemInformation.DoubleClickSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("DoubleClickTime")
            .SubItems.Add(SystemInformation.DoubleClickTime.ToString())
        End With
        With lvwSystemInformation.Items.Add("DragFullWindows")
            .SubItems.Add(SystemInformation.DragFullWindows.ToString())
        End With
        With lvwSystemInformation.Items.Add("DragSize")
            .SubItems.Add(SystemInformation.DragSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("FixedFrameBorderSize")
            .SubItems.Add(SystemInformation.FixedFrameBorderSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("FrameBorderSize")
            .SubItems.Add(SystemInformation.FrameBorderSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("HighContrast")
            .SubItems.Add(SystemInformation.HighContrast.ToString())
        End With
        With lvwSystemInformation.Items.Add("HorizontalScrollBarArrowWidth")
            .SubItems.Add(SystemInformation.HorizontalScrollBarArrowWidth.ToString())
        End With
        With lvwSystemInformation.Items.Add("HorizontalScrollBarHeight")
            .SubItems.Add(SystemInformation.HorizontalScrollBarHeight.ToString())
        End With
        With lvwSystemInformation.Items.Add("HorizontalScrollBarThumbWidth")
            .SubItems.Add(SystemInformation.HorizontalScrollBarThumbWidth.ToString())
        End With
        With lvwSystemInformation.Items.Add("IconSize")
            .SubItems.Add(SystemInformation.IconSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("IconSpacingSize")
            .SubItems.Add(SystemInformation.IconSpacingSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("KanjiWindowHeight")
            .SubItems.Add(SystemInformation.KanjiWindowHeight.ToString())
        End With
        With lvwSystemInformation.Items.Add("MaxWindowTrackSize")
            .SubItems.Add(SystemInformation.MaxWindowTrackSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("MenuButtonSize")
            .SubItems.Add(SystemInformation.MenuButtonSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("MenuCheckSize")
            .SubItems.Add(SystemInformation.MenuCheckSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("MenuFont")
            .SubItems.Add(SystemInformation.MenuFont.ToString())
        End With
        With lvwSystemInformation.Items.Add("MenuHeight")
            .SubItems.Add(SystemInformation.MenuHeight.ToString())
        End With
        With lvwSystemInformation.Items.Add("MidEastEnabled")
            .SubItems.Add(SystemInformation.MidEastEnabled.ToString())
        End With
        With lvwSystemInformation.Items.Add("MinimizedWindowSize")
            .SubItems.Add(SystemInformation.MinimizedWindowSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("MinimizedWindowSpacingSize")
            .SubItems.Add(SystemInformation.MinimizedWindowSpacingSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("MinimumWindowSize")
            .SubItems.Add(SystemInformation.MinimumWindowSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("MinWindowTrackSize")
            .SubItems.Add(SystemInformation.MinWindowTrackSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("MonitorCount")
            .SubItems.Add(SystemInformation.MonitorCount.ToString())
        End With
        With lvwSystemInformation.Items.Add("MonitorsSameDisplayFormat")
            .SubItems.Add(SystemInformation.MonitorsSameDisplayFormat.ToString())
        End With
        With lvwSystemInformation.Items.Add("MouseButtons")
            .SubItems.Add(SystemInformation.MouseButtons.ToString())
        End With
        With lvwSystemInformation.Items.Add("MouseButtonsSwapped")
            .SubItems.Add(SystemInformation.MouseButtonsSwapped.ToString())
        End With
        With lvwSystemInformation.Items.Add("MousePresent")
            .SubItems.Add(SystemInformation.MousePresent.ToString())
        End With
        With lvwSystemInformation.Items.Add("MouseWheelPresent")
            .SubItems.Add(SystemInformation.MouseWheelPresent.ToString())
        End With
        With lvwSystemInformation.Items.Add("MouseWheelScrollLines")
            .SubItems.Add(SystemInformation.MouseWheelScrollLines.ToString())
        End With
        With lvwSystemInformation.Items.Add("NativeMouseWheelSupport")
            .SubItems.Add(SystemInformation.NativeMouseWheelSupport.ToString())
        End With
        With lvwSystemInformation.Items.Add("Network")
            .SubItems.Add(SystemInformation.Network.ToString())
        End With
        With lvwSystemInformation.Items.Add("PenWindows")
            .SubItems.Add(SystemInformation.PenWindows.ToString())
        End With
        With lvwSystemInformation.Items.Add("PrimaryMonitorMaximizedWindowSize")
            .SubItems.Add(SystemInformation.PrimaryMonitorMaximizedWindowSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("PrimaryMonitorSize")
            .SubItems.Add(SystemInformation.PrimaryMonitorSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("RightAlignedMenus")
            .SubItems.Add(SystemInformation.RightAlignedMenus.ToString())
        End With
        With lvwSystemInformation.Items.Add("Secure")
            .SubItems.Add(SystemInformation.Secure.ToString())
        End With
        With lvwSystemInformation.Items.Add("ShowSounds")
            .SubItems.Add(SystemInformation.ShowSounds.ToString())
        End With
        With lvwSystemInformation.Items.Add("SmallIconSize")
            .SubItems.Add(SystemInformation.SmallIconSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("ToolWindowCaptionButtonSize")
            .SubItems.Add(SystemInformation.ToolWindowCaptionButtonSize.ToString())
        End With
        With lvwSystemInformation.Items.Add("ToolWindowCaptionHeight")
            .SubItems.Add(SystemInformation.ToolWindowCaptionHeight.ToString())
        End With
        With lvwSystemInformation.Items.Add("UserDomainName")
            .SubItems.Add(SystemInformation.UserDomainName.ToString())
        End With
        With lvwSystemInformation.Items.Add("UserInteractive")
            .SubItems.Add(SystemInformation.UserInteractive.ToString())
        End With
        With lvwSystemInformation.Items.Add("UserName")
            .SubItems.Add(SystemInformation.UserName.ToString())
        End With
        With lvwSystemInformation.Items.Add("VerticalScrollBarArrowHeight")
            .SubItems.Add(SystemInformation.VerticalScrollBarArrowHeight.ToString())
        End With
        With lvwSystemInformation.Items.Add("VerticalScrollBarThumbHeight")
            .SubItems.Add(SystemInformation.VerticalScrollBarThumbHeight.ToString())
        End With
        With lvwSystemInformation.Items.Add("VerticalScrollBarWidth")
            .SubItems.Add(SystemInformation.VerticalScrollBarWidth.ToString())
        End With
        With lvwSystemInformation.Items.Add("VirtualScreen")
            .SubItems.Add(SystemInformation.VirtualScreen.ToString())
        End With
        With lvwSystemInformation.Items.Add("WorkingArea")
            .SubItems.Add(SystemInformation.WorkingArea.ToString())
        End With
    End Sub

    Private Sub RunMethods()
        ' Environment.GetLogicalDrives 返回一个
        ' 驱动器名称数组。可以循环访问该数组，
        ' 就像使用任何其他数组一样，
        ' 也可以将该数组用作列表
        ' 的数据源，如下所示。

        ' 在获得驱动器列表后，您可能
        ' 希望检索有关这些驱动器上的
        ' 文件的信息。有关使用这些
        ' 逻辑实体的更多信息，请参见
        ' File 和 Directory 类。
        lstLogicalDrives.DataSource = _
        Environment.GetLogicalDrives()

        lstCommandLineArgs.DataSource = _
        Environment.GetCommandLineArgs()
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
